/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;

public class LeverBlock
extends FaceAttachedHorizontalDirectionalBlock {
    public static final BooleanProperty f_54622_ = BlockStateProperties.f_61448_;
    protected static final int f_153653_ = 6;
    protected static final int f_153654_ = 6;
    protected static final int f_153655_ = 8;
    protected static final VoxelShape f_54623_ = Block.m_49796_(5.0, 4.0, 10.0, 11.0, 12.0, 16.0);
    protected static final VoxelShape f_54624_ = Block.m_49796_(5.0, 4.0, 0.0, 11.0, 12.0, 6.0);
    protected static final VoxelShape f_54625_ = Block.m_49796_(10.0, 4.0, 5.0, 16.0, 12.0, 11.0);
    protected static final VoxelShape f_54626_ = Block.m_49796_(0.0, 4.0, 5.0, 6.0, 12.0, 11.0);
    protected static final VoxelShape f_54627_ = Block.m_49796_(5.0, 0.0, 4.0, 11.0, 6.0, 12.0);
    protected static final VoxelShape f_54628_ = Block.m_49796_(4.0, 0.0, 5.0, 12.0, 6.0, 11.0);
    protected static final VoxelShape f_54629_ = Block.m_49796_(5.0, 10.0, 4.0, 11.0, 16.0, 12.0);
    protected static final VoxelShape f_54630_ = Block.m_49796_(4.0, 10.0, 5.0, 12.0, 16.0, 11.0);

    public LeverBlock(BlockBehaviour.Properties p_54633_) {
        super(p_54633_);
        this.m_49959_((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH))).m_61124_((Property)f_54622_, Boolean.valueOf(false)))).m_61124_((Property)f_53179_, (Comparable)AttachFace.WALL)));
    }

    public VoxelShape m_5940_(BlockState p_54665_, BlockGetter p_54666_, BlockPos p_54667_, CollisionContext p_54668_) {
        switch ((AttachFace)p_54665_.m_61143_((Property)f_53179_)) {
            case FLOOR: {
                switch (((Direction)p_54665_.m_61143_((Property)f_54117_)).m_122434_()) {
                    case X: {
                        return f_54628_;
                    }
                }
                return f_54627_;
            }
            case WALL: {
                switch ((Direction)p_54665_.m_61143_((Property)f_54117_)) {
                    case EAST: {
                        return f_54626_;
                    }
                    case WEST: {
                        return f_54625_;
                    }
                    case SOUTH: {
                        return f_54624_;
                    }
                }
                return f_54623_;
            }
        }
        switch (((Direction)p_54665_.m_61143_((Property)f_54117_)).m_122434_()) {
            case X: {
                return f_54630_;
            }
        }
        return f_54629_;
    }

    public InteractionResult m_6227_(BlockState p_54640_, Level p_54641_, BlockPos p_54642_, Player p_54643_, InteractionHand p_54644_, BlockHitResult p_54645_) {
        if (p_54641_.f_46443_) {
            BlockState blockstate1 = (BlockState)((Object)p_54640_.m_61122_((Property)f_54622_));
            if (((Boolean)blockstate1.m_61143_((Property)f_54622_)).booleanValue()) {
                LeverBlock.m_54657_(blockstate1, p_54641_, p_54642_, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        boolean powered = (Boolean)p_54640_.m_61143_((Property)f_54622_);
        org.bukkit.block.Block block = p_54641_.getWorld().getBlockAt(p_54642_.m_123341_(), p_54642_.m_123342_(), p_54642_.m_123343_());
        int old = powered ? 15 : 0;
        int current = !powered ? 15 : 0;
        BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(block, old, current);
        p_54641_.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
        if (eventRedstone.getNewCurrent() > 0 != !powered) {
            return InteractionResult.SUCCESS;
        }
        BlockState blockstate = this.m_54676_(p_54640_, p_54641_, p_54642_);
        float f = (Boolean)blockstate.m_61143_((Property)f_54622_) != false ? 0.6f : 0.5f;
        p_54641_.m_5594_(null, p_54642_, SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, f);
        p_54641_.m_142346_(p_54643_, (Boolean)blockstate.m_61143_((Property)f_54622_) != false ? GameEvent.f_157799_ : GameEvent.f_157801_, p_54642_);
        return InteractionResult.CONSUME;
    }

    public BlockState m_54676_(BlockState p_54677_, Level p_54678_, BlockPos p_54679_) {
        p_54677_ = (BlockState)((Object)p_54677_.m_61122_((Property)f_54622_));
        p_54678_.m_7731_(p_54679_, p_54677_, 3);
        this.m_54680_(p_54677_, p_54678_, p_54679_);
        return p_54677_;
    }

    private static void m_54657_(BlockState p_54658_, LevelAccessor p_54659_, BlockPos p_54660_, float p_54661_) {
        Direction direction = ((Direction)p_54658_.m_61143_((Property)f_54117_)).m_122424_();
        Direction direction1 = LeverBlock.m_53200_((BlockState)p_54658_).m_122424_();
        double d0 = (double)p_54660_.m_123341_() + 0.5 + 0.1 * (double)direction.m_122429_() + 0.2 * (double)direction1.m_122429_();
        double d1 = (double)p_54660_.m_123342_() + 0.5 + 0.1 * (double)direction.m_122430_() + 0.2 * (double)direction1.m_122430_();
        double d2 = (double)p_54660_.m_123343_() + 0.5 + 0.1 * (double)direction.m_122431_() + 0.2 * (double)direction1.m_122431_();
        p_54659_.m_7106_((ParticleOptions)new DustParticleOptions(DustParticleOptions.f_175788_, p_54661_), d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public void m_7100_(BlockState p_54653_, Level p_54654_, BlockPos p_54655_, Random p_54656_) {
        if (((Boolean)p_54653_.m_61143_((Property)f_54622_)).booleanValue() && p_54656_.nextFloat() < 0.25f) {
            LeverBlock.m_54657_(p_54653_, p_54654_, p_54655_, 0.5f);
        }
    }

    public void m_6810_(BlockState p_54647_, Level p_54648_, BlockPos p_54649_, BlockState p_54650_, boolean p_54651_) {
        if (!p_54651_ && !p_54647_.m_60713_(p_54650_.m_60734_())) {
            if (((Boolean)p_54647_.m_61143_((Property)f_54622_)).booleanValue()) {
                this.m_54680_(p_54647_, p_54648_, p_54649_);
            }
            super.m_6810_(p_54647_, p_54648_, p_54649_, p_54650_, p_54651_);
        }
    }

    public int m_6378_(BlockState p_54635_, BlockGetter p_54636_, BlockPos p_54637_, Direction p_54638_) {
        return (Boolean)p_54635_.m_61143_((Property)f_54622_) != false ? 15 : 0;
    }

    public int m_6376_(BlockState p_54670_, BlockGetter p_54671_, BlockPos p_54672_, Direction p_54673_) {
        return (Boolean)p_54670_.m_61143_((Property)f_54622_) != false && LeverBlock.m_53200_((BlockState)p_54670_) == p_54673_ ? 15 : 0;
    }

    public boolean m_7899_(BlockState p_54675_) {
        return true;
    }

    private void m_54680_(BlockState p_54681_, Level p_54682_, BlockPos p_54683_) {
        p_54682_.m_46672_(p_54683_, (Block)((Object)this));
        p_54682_.m_46672_(p_54683_.m_142300_(LeverBlock.m_53200_((BlockState)p_54681_).m_122424_()), (Block)((Object)this));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_54663_) {
        p_54663_.m_61104_(new Property[]{f_53179_, f_54117_, f_54622_});
    }
}

